/*
 * Decompiled with CFR 0.152.
 */
package eu.thesociety.DragonbornSR.DragonsRadioMod.player;

import eu.thesociety.DragonbornSR.DragonsRadioMod.Block.BlockRadio;
import eu.thesociety.DragonbornSR.DragonsRadioMod.player.DPlayBackEvent;
import eu.thesociety.DragonbornSR.DragonsRadioMod.player.DPlaybackListener;
import java.io.InputStream;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.SampleBuffer;
import javazoom.jl.player.AudioDevice;
import javazoom.jl.player.FactoryRegistry;
import javazoom.jl.player.advanced.PlaybackEvent;
import net.minecraft.world.World;

public class DAdvancedPlayer {
    private final Bitstream bitstream;
    private final Decoder decoder;
    private AudioDevice audio;
    private boolean closed = false;
    private boolean complete = false;
    private int lastPosition = 0;
    private DPlaybackListener listener;
    private float volume = 0.0f;
    private int posX;
    private int posY;
    private int posZ;
    private World world;

    public DAdvancedPlayer(InputStream stream) throws JavaLayerException {
        this(stream, null);
    }

    public DAdvancedPlayer(InputStream stream, AudioDevice device) throws JavaLayerException {
        this.bitstream = new Bitstream(stream);
        this.audio = device != null ? device : FactoryRegistry.systemRegistry().createAudioDevice();
        this.decoder = new Decoder();
        this.audio.open(this.decoder);
    }

    public void setID(World w, int x, int y, int z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.world = w;
    }

    public void play() throws JavaLayerException {
        this.play(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean play(int frames) throws JavaLayerException {
        boolean ret = true;
        if (this.listener != null) {
            this.listener.playbackStarted(this.createEvent(PlaybackEvent.STARTED));
        }
        while (frames-- > 0 && ret) {
            if (!(this.world.func_147439_a(this.posX, this.posY, this.posZ) instanceof BlockRadio)) {
                this.close();
            }
            ret = this.decodeFrame();
        }
        AudioDevice out = this.audio;
        if (out != null) {
            out.flush();
            DAdvancedPlayer dAdvancedPlayer = this;
            synchronized (dAdvancedPlayer) {
                this.complete = !this.closed;
                this.close();
            }
            if (this.listener != null) {
                this.listener.playbackFinished(this.createEvent(out, PlaybackEvent.STOPPED));
            }
        }
        return ret;
    }

    public synchronized void close() {
        AudioDevice out = this.audio;
        if (out != null) {
            this.closed = true;
            this.audio = null;
            out.close();
            this.lastPosition = out.getPosition();
            try {
                this.bitstream.close();
            }
            catch (BitstreamException bitstreamException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean decodeFrame() throws JavaLayerException {
        try {
            AudioDevice out = this.audio;
            if (out == null) {
                return false;
            }
            Header h = this.bitstream.readFrame();
            if (h == null) {
                return false;
            }
            SampleBuffer output = (SampleBuffer)this.decoder.decodeFrame(h, this.bitstream);
            DAdvancedPlayer dAdvancedPlayer = this;
            synchronized (dAdvancedPlayer) {
                out = this.audio;
                if (out != null) {
                    short[] samples = output.getBuffer();
                    for (int samp = 0; samp < samples.length; ++samp) {
                        samples[samp] = (short)((float)samples[samp] * this.volume);
                    }
                    out.write(samples, 0, output.getBufferLength());
                }
            }
            this.bitstream.closeFrame();
            return true;
        }
        catch (RuntimeException var9) {
            throw new JavaLayerException("Exception decoding audio frame", var9);
        }
    }

    protected boolean skipFrame() throws JavaLayerException {
        Header h = this.bitstream.readFrame();
        if (h == null) {
            return false;
        }
        this.bitstream.closeFrame();
        return true;
    }

    public boolean play(int start, int end) throws JavaLayerException {
        boolean ret = true;
        int var4 = start;
        while (var4-- > 0 && ret) {
            ret = this.skipFrame();
        }
        return this.play(end - start);
    }

    private DPlayBackEvent createEvent(int id) {
        return this.createEvent(this.audio, id);
    }

    private DPlayBackEvent createEvent(AudioDevice dev, int id) {
        return new DPlayBackEvent(this, id, dev.getPosition());
    }

    public DPlaybackListener getPlayBackListener() {
        return this.listener;
    }

    public void setPlayBackListener(DPlaybackListener listener) {
        this.listener = listener;
    }

    public void stop() {
        this.listener.playbackFinished(this.createEvent(DPlayBackEvent.STOPPED));
        this.close();
    }

    public float getVolume() {
        return this.volume;
    }

    public void setVolume(float f) {
        this.volume = f;
    }
}

